#include <bits/stdc++.h>

#define int long long

signed main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);

    int n;
    std::cin >> n;

    int rows = 2 * n - 1;

    std::string line;
    std::getline(std::cin, line);

    std::vector<std::vector<int> > hex(rows);
    for (int i = 0; i < rows; ++i) {
        getline(std::cin, line);
        std::stringstream ss(line);
        int value;
        while (ss >> value) {
            hex[i].push_back(value);
        }
    }
    std::string operations;
    std::cin >> operations;

    int center = n - 1;
    auto q_min = [&](int i) -> int {
        int r = i - center;
        return std::max(-center, -r - center);
    };

    int rotations = 0;
    int flips = 0;
    for (char c: operations) {
        if (c == 'R') {
            rotations = (rotations + 1) % 6;
        } else if (c == 'L') {
            rotations = (rotations + 5) % 6;
        } else if (c == 'T') {
            flips ^= 1;
            rotations = (6 - rotations) % 6;
        }
    }

    auto apply_k_ops = [&](int x, int y, int z, int k) {
        k %= 6;
        switch (k) {
            case 0:
                return std::array<int, 3>{x, y, z};
            case 1:
                return std::array<int, 3>{-z, -x, -y};
            case 2:
                return std::array<int, 3>{y, z, x};
            case 3:
                return std::array<int, 3>{-x, -y, -z};
            case 4:
                return std::array<int, 3>{z, x, y};
            default:
                return std::array<int, 3>{-y, -z, -x};
        }
    };

    int inverted = (6 - rotations) % 6;

    for (int i = 0; i < rows; ++i) {
        int r = i - center;
        int qmin = q_min(i);
        int len = static_cast<int>(hex[i].size());
        for (int j = 0; j < len; ++j) {
            int q = qmin + j;
            int x = q, z = r, y = -x - z;
            auto c1 = apply_k_ops(x, y, z, inverted);
            int x2 = c1[0], y2 = c1[1], z2 = c1[2];
            int x0 = x2, y0 = y2, z0 = z2;
            if (flips) {
                x0 = y2;
                y0 = x2;
                z0 = z2;
            }
            int q0 = x0, r0 = z0;
            int i0 = r0 + center;
            int val = 0;
            if (0 <= i0 && i0 < rows) {
                int qmin0 = q_min(i0);
                int j0 = q0 - qmin0;
                if (0 <= j0 && j0 < static_cast<int>(hex[i0].size())) {
                    val = hex[i0][j0];
                } else {
                    val = 0;
                }
            } else {
                val = 0;
            }
            std::cout << val << ' ';
        }
        std::cout << '\n';
    }
}
