def piano():
    import sys
    input = sys.stdin.readline
    kolichestvo = int(input())
    white_notes = "ABCDEFG"
    note_to_index = {note: i for i, note in enumerate(white_notes)}

    notes_positions = [[] for _ in range(7)]
    for i in range(52):
        notes_positions[i % 7].append(i)
 
    transitions = [set() for _ in range(52)]
    for pos in range(52):
        for next_pos in range(max(0, pos - 3), min(52, pos + 4)):
            transitions[pos].add(next_pos)
    
    for _ in range(kolichestvo):
        melodia = input().strip()
        if not melodia:
            continue
            
        current_positions = set(notes_positions[note_to_index[melodia[0]]])
        
        for note in melodia[1:]:
            next_note_positions = notes_positions[note_to_index[note]]
            new_positions = set()
            
            for pos in current_positions:
                for next_pos in transitions[pos]:
                    if next_pos in next_note_positions:
                        new_positions.add(next_pos)
            
            current_positions = new_positions
            if not current_positions:
                break
        
        print("Yes" if current_positions else "No")


piano()
        
