#include <cstdlib>
#include <iostream>
#include <queue>
#include <set>
#include <string>
#include <unordered_map>
#include <vector>

using namespace std;

bool checkOneLine(string &line, unordered_map<char, vector<int>> &pos) {
  queue<pair<int, int>> q;

  set<pair<int, int>> v;

  int size = line.size();

  char n = line[0];
  for (int p : pos[n]) {
    q.push({0, p});
    v.insert({0, p});
  }

  bool canPl = false;

  while (!q.empty()) {
    auto [n, p] = q.front();
    q.pop();

    if (n == size - 1) {
      canPl = true;
      break;
    }

    char next = line[n + 1];
    int nextI = n + 1;

    for (int noteP : pos[next]) {
      if (abs(p - noteP) <= 3) {
        if (v.find({nextI, noteP}) == v.end()) {
          v.insert({nextI, noteP});
          q.push({nextI, noteP});
        }
      }
    }
  }
  return canPl;
}

int main() {

  int t;

  int nC = 7;
  unordered_map<char, vector<int>> pos;
  pos['A'] = {0, 7, 14, 21, 28, 35, 42, 49};
  pos['B'] = {1, 8, 15, 22, 29, 36, 43, 50};
  pos['C'] = {2, 9, 16, 23, 30, 37, 44, 51};
  pos['D'] = {3, 10, 17, 24, 31, 38, 45};
  pos['E'] = {4, 11, 18, 25, 32, 39, 46};
  pos['F'] = {5, 12, 19, 26, 33, 40, 47};
  pos['G'] = {6, 13, 20, 27, 34, 41, 48};
  string currentS;

  cin >> t;
  cin.ignore();

  for (int i = 0; i < t; i++) {
    getline(cin, currentS);

    if (checkOneLine(currentS, pos))
      cout << "YES" << "\n";
    else
      cout << "NO" << "\n";
  }
}
