def get_gex(n):
    gex = []
    for _ in range(n * 2 - 1):
        gex.append(list(map(int, input().split())))
    return gex

def rotate_to_l(gex, n):
    size = len(gex)
    result = []
    n1 = n - 1
    n2 = 2 * n - 2
    
    for i in range(size):
        row_len = len(gex[i])
        new_row = []
        col_start = max(0, n1 - i)
        row_start = max(0, i - n1)
        max_col = n2 - i
        
        for j in range(row_len):
            row = row_start + j
            col = min(col_start + j, max_col)
            new_row.append(gex[row][col])
        
        result.append(new_row)
    
    return result

def print_gex(gex, n):
    for i in range(n * 2 - 1):
        print(" " * abs(n - i - 1), *gex[i], sep=" ")


n = int(input())
gex = get_gex(n)

# Бьём строку команд на строчки последовательных разворотов
commands = input().split('T')
# Высчитываем сколько раз нужно будет отразить по горизонтали
count_reverse = len(commands) - 1
# Поочерёдно поворачиваем на итоговый угол поворота для каждой последовательности
for i in range(len(commands)):
    # Вычисляем общий угол поворота
    degree = commands[i].count('L') * -60 + commands[i].count('R') * 60
    # Отсекаем лишние градусы
    degree %= -360 if degree < 0 else 360
    if degree > 0:
        degree -= 360

    # Поворачиваем нужное кол-во раз
    for _ in range(degree // -60):
        gex = rotate_to_l(gex, n)
    
    # Отражаем (если нужно)
    if count_reverse:
        gex = [line[::-1] for line in gex]
        count_reverse -= 1

print_gex(gex, n)
