﻿
#include <iostream>
#include <vector>
#include <string>
#include <unordered_map>
#include <set>

bool pl(const std::string& s) {
    std::unordered_map<char, int> note = { {'A',0}, {'B',1}, {'C',2}, {'D',3}, {'E',4}, {'F',5}, {'G',6} };

    std::vector<int> cpos;
    int fnote = note[s[0]];
    for (int i = 0; i < 8; i++) {
        int pos = fnote + 7 * i;
        if (pos < 52) {
            cpos.push_back(pos);
        }
    }

    for (size_t idx = 1; idx < s.length(); idx++) {
        std::set<int> npos;
        int tnote = note[s[idx]];

        for (int pos : cpos) {
            for (int oct = 0; oct < 8; oct++) {
                int ca = tnote + 7 * oct;
                if (ca >= 0 && ca < 52 && std::abs(ca - pos) <= 3) {
                    npos.insert(ca);
                }
            }
        }

        if (npos.empty()) {
            return false;
        }

        cpos.assign(npos.begin(), npos.end());
    }

    return true;
}

int main() {
    int t;
    std::cin >> t;
    std::cin.ignore();

    std::vector<std::string> results;

    for (int i = 0; i < t; i++) {
        std::string s;
        std::getline(std::cin, s);

        if (pl(s)) {
            results.push_back("Yes");
        }
        else {
            results.push_back("No");
        }
    }

    for (const std::string& result : results) {
        std::cout << result << std::endl;
    }

    return 0;
}