import sys

def fast_io():
    sys.stdin.readline
    
def solve():
    MOD = 1_000_000_007
    
    try:
        t_str = sys.stdin.readline()
        if not t_str: return
        t = int(t_str)
        
        for _ in range(t):
            p, m = map(int, sys.stdin.readline().split())
            
            num = (4 * p + 2 * m + 2) % MOD
            denom = m + 2
            
            inv_denom = pow(denom, MOD - 2, MOD)
            
            res = (num * inv_denom) % MOD
            print(res)
            
    except (IOError, ValueError):
        return

if __name__ == "__main__":
    solve()