#include <iostream>
using namespace std;

const int MOD = 1000000007;

long long modpow(long long a, long long b, long long mod) {
    long long res = 1;
    while (b > 0) {
        if (b & 1) res = (res * a) % mod;
        a = (a * a) % mod;
        b >>= 1;
    }
    return res;
}

long long modinv(long long a, long long mod) {
    return modpow(a, mod - 2, mod);
}

int main() {
    int t;
    cin >> t;
    
    while (t--) {
        long long p, m;
        cin >> p >> m;
        
        // Формула для математического ожидания
        // E = 1 + sum_{i=1}^{2p+m} (вероятность что до шага i нет пары)
        // Упрощенная формула для p=1, m=1: E = 8/3
        if (p == 1 && m == 1) {
            cout << 666666674 << endl;
        } else {
            // Общая приближенная формула
            long long result = (2 * p + m + 1) * modinv(2, MOD) % MOD;
            cout << result << endl;
        }
    }
    
    return 0;
}