#ifndef _GLIBCXX_NO_ASSERT
#include <cassert>
#endif
#include <cctype>
#include <cerrno>
#include <cfloat>
#include <ciso646>
#include <climits>
#include <clocale>
#include <cmath>
#include <csetjmp>
#include <csignal>
#include <cstdarg>
#include <cstddef>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <ctime>
 
#if __cplusplus >= 201103L
#include <ccomplex>
#include <cfenv>
#include <cinttypes>
#include <cstdbool>
#include <cstdint>
#include <ctgmath>
#include <cwchar>
#include <cwctype>
#endif
 
// C++
#include <algorithm>
#include <bitset>
#include <complex>
#include <deque>
#include <exception>
#include <fstream>
#include <functional>
#include <iomanip>
#include <ios>
#include <iosfwd>
#include <iostream>
#include <istream>
#include <iterator>
#include <limits>
#include <list>
#include <locale>
#include <map>
#include <memory>
#include <new>
#include <numeric>
#include <ostream>
#include <queue>
#include <set>
#include <sstream>
#include <stack>
#include <stdexcept>
#include <streambuf>
#include <string>
#include <typeinfo>
#include <utility>
#include <valarray>
#include <vector>
 
#if __cplusplus >= 201103L
#include <array>
#include <atomic>
#include <chrono>
#include <condition_variable>
#include <forward_list>
#include <future>
#include <initializer_list>
#include <mutex>
#include <random>
#include <ratio>
#include <regex>
#include <scoped_allocator>
#include <system_error>
#include <thread>
#include <tuple>
#include <type_traits>
#include <typeindex>
#include <unordered_map>
#include <unordered_set>
#endif

using namespace std;

#define int long long
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define Sz(x) ((int)(x).size())
#define rep(i, a, b) for(int i = a; i < (b); ++i)
#define eb emplace_back
#define pb push_back 
#define mkpair make_pair

using ld = long double;
[[maybe_unused]] constexpr static int INF = (int) 1e18 + 10 + 300 + 5251 + 14154;
using pii = pair<int, int>;
using vi = vector<int>;
using vvi = vector<vi>;
using vvvi = vector<vvi>;
using vpi = vector<pii>;
#ifdef LOCAL
void debugPrint(int integer) {cerr << integer;}
void debugPrint(float kek) {cerr << kek;}
void debugPrint(double kek) {cerr << kek;}
void debugPrint(std::string s) {cerr << "\"" << s << "\"";}
void debugPrint(const char* s) {cerr << "\"" << s << "\"";}
void debugPrint(bool b) {cerr << (b ? "true" : "false");}
void debugPrint(char  c) {cerr << "\'" << c << "\'";}
template <typename F, typename S>
void debugPrint(const pair<F, S> & p) { cerr << "{"; debugPrint(p.first); cerr << ", "; debugPrint(p.second); cerr << "}";}
template<typename T>
void debugPrint(complex<T> c) { cerr << "{"; debugPrint(c.real()); cerr << ", "; debugPrint(c.imag()); cerr << "}";}
template <template <typename> class Container, typename T>
void debugPrint(Container<T>& container) {
    cerr << "{";
    for (auto it = container.begin(); it != container.end(); ++it) {
        if (it == container.begin()) {
            debugPrint(*it);
        } else {
            cerr << ", ";
            debugPrint(*it);
        }
    }
    cerr << "}";
}
void debugPrint() {}
template <typename Head, typename... Tail>
void debugPrint(Head head, Tail... tail) {
    debugPrint(head); if (sizeof...(tail) != 0) {
        cerr << ", ";
    }
    debugPrint(tail...);
}
#endif
#ifdef LOCAL
#define debug(x...) cerr << "[" << #x << "] = ["; debugPrint(x); cerr << "]\n";
#else
#define debug(x...) 52
#endif

const int MOD = (int)1e9 + 7;
const int maxn = (int)2e6 + 123;
vector<int> fact(maxn);

void precalc() {
    fact[0] = 1;
    for (int i = 1; i < maxn; i++) {
        fact[i] = (fact[i - 1] * i) % MOD;
    }
}

int bpow(int x, int y) {
    if (y == 0) {
        return 1;
    }
    if (y == 1) {
        return x % MOD;
    }
    if (y % 2 == 0) {
        int tmp = bpow(x, y / 2);
        return (tmp * tmp) % MOD;
    }
    int tmp = bpow(x, y - 1);
    return (x * tmp) % MOD;
}

int inv(int x) {
    return bpow(x, MOD - 2);
}

int c(int n, int k) {
    int res = fact[n];
    res *= inv(fact[k]);
    res %= MOD;
    res *= inv(fact[n - k]);
    res %= MOD;
    return res;
}


vpi convex_hull(vpi &kek) {
    vpi p = kek;
    sort(all(p));
    auto end = std::unique(p.begin(), p.end());
    int n = end - p.begin();
    while (p.size() != n) {
        p.pop_back();
    }

    auto st = p[0];
    p.erase(p.begin());
    --n;

    auto sign = [&] (const auto& from, const auto& p1, const auto& p2) -> int {
        auto [x1, y1] = p1;
        auto [x2, y2] = p2;
        auto [x, y ] = from;
        x1-=x; x2-=x;
        y1-=y; y2-=y;
        
        return x2 * y1 - x1 * y2;
    };

    sort(all(p), [&](const auto& a, const auto& b) {
        int rot = sign(st, a, b);
        if (rot == 0) {
            return a < b;
        }
        return rot > 0;
    });

    vector<pair<int, int>> ans = {st};
    for (auto i : p) {
        while (ans.size() >= 2) {
            if (sign(ans[ans.size() - 2], ans[ans.size() - 1], i) <= 0) {
                ans.pop_back();
            } else {
                break;
            }
        }
        ans.push_back(i);
    }

    return ans;
}

void solve(int number_test) {
    int n;
    cin >> n;
    vector<pair<int, int>> p(n);
    for (auto& [x, y] : p) {
        cin >> x >> y;
    }

    p = convex_hull(p);
    for (auto& el : p) {
        debug(el);
    }
    n = p.size();

    ld max_dist = -1;
    int a1{},b1{},c1{};
    int a2{},b2{},c2{};

    auto dist = [&] (const auto& i, const auto& j) {
        ld dx = p[i].first - p[j].first;
        ld dy = p[i].second - p[j].second;
        return sqrtl(dx*dx+dy*dy);
    };

    auto idx1 = -1;
    auto idx2 = -1;

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            int delta = (i - j + n) % n;
            // if (delta <= 1) continue;
            if (delta == 0)continue;
            
            auto cur_dist = dist(i, j);
            if (cur_dist > max_dist) {
                max_dist = cur_dist; 

                idx1 = i;
                idx2 = j;
            }
        }
    }
    int i = idx1;
    int j = idx2;
    int dx = p[j].first - p[i].first;
    int dy = p[j].second - p[i].second;
    
    int a = dx;
    int b = dy;
    cout << a << " " << b << " " << -a * p[i].first + -b * p[i].second << "\n";
    cout << a << " " << b << " " << -a * p[j].first + -b * p[j].second  << "\n";

    // cout << max_dist << "\n";

    // for (int i = 0; i < n; i++) {
    //     for (int j = 0; j < n; j++) {
    //         if (i == j || (i+1)%n == j) {
    //             continue;
    //         }

    //         // auto [x1, y1] = p[i];
    //         // auto [x2, y2] = p[(i + 1) % n];
    //         // auto [x3, y3] = p[j];

    //         // int a = y1 - y2;
    //         // int b = x2 - x1; 
    //         // int c = x1*y2 - x2*y1;

    //         // ld dist = abs(ld(a) * x3 + ld(b) * y3 + c);
    //         // dist /= sqrtl(ld(a)*a + ld(b)*b);
            
    //         // cerr << "dist: " << dist << endl;

    //         // if (dist > max_dist) {
    //         //     a1 = a;
    //         //     b1 = b;
    //         //     c1 = c;

    //         //     a2 = a;
    //         //     b2 = b;
    //         //     c2 = -a * x3 - b * y3;
                   
    //         // }

    //     }
    // }
    // cout << a1 << " " << b1 << " " << c1 << "\n";
    // cout << a2 << " " << b2 << " " << c2 << "\n";

}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

#ifdef LOCAL 
    freopen("input.txt", "r", stdin);
#endif

    precalc();

    int nt = 1;
    // cin >> nt;
    for (int i = 1; i <= nt; i++) {
        solve(i);
    }
}
