#include <algorithm>
#include <bitset>
#include <chrono>
#include <climits>
#include <cmath>
#include <fstream>
#include <functional>
#include <iostream>
#include <list>
#include <map>
#include <numeric>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>

using namespace std;

template<class T>
ostream &operator<<(ostream &out, const vector<T> &a) {
    for (auto &i: a) out << i << " ";
    return out;
}

template<class T>
T read() {
    T t;
    cin >> t;
    return t;
}

template<class T>
void operator>>(istream &in, vector<T> &a) { for (auto &i: a) in >> i; }

template<class T>
void operator>>(istream &in, vector<vector<T>> &a) { for (auto &i: a) in >> i; }

#define ll long long
#define ull unsigned ll
#define ld long double
#define M_PI 3.14159265358979323846
#define all(x) x.begin(), x.end()
#define rall(x) x.rbegin(), x.rend()
#define X first
#define Y second
#define int ll

constexpr ll MOD = 998244353;

void solution() {
    int t = read<int>();
    constexpr int n = 52;
    constexpr string c = "ABCDEFG";
    vector<char> k(n);
    for (int i = 0; i < n; ++i) {
        k[i] = c[i % 7];
    }

    vector<vector<int>> pos(7);
    for (int i = 0; i < n; ++i) {
        pos[k[i] - 'A'].push_back(i);
    }

    while (t--) {
        auto str = read<string>();
        vector<char> tmp(n, 0);
        for (auto &&p: pos[str[0] - 'A']) {
            tmp[p] = 1;
        }

        bool ok = true;
        for (int r = 1; r < str.size() && ok; ++r) {
            vector<char> nxt(n, 0);
            int flag = str[r] - 'A';
            for (auto &&q: pos[flag]) {
                for (int dp = -3; dp <= 3; ++dp) {
                    int p = q + dp;
                    if (0 <= p && p < n && tmp[p]) {
                        nxt[q] = 1;
                        break;
                    }
                }
            }

            tmp.swap(nxt);
            bool any = false;
            for (int i = 0; i < n; ++i) {
                if (tmp[i]) {
                    any = true;
                    break;
                }
            }

            if (!any) {
                ok = false;
            }
        }

        cout << (ok ? "YES" : "NO") << '\n';
    }

}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
//    auto ttt = read<int>();
    auto ttt = 1;
    while (ttt--) solution();
}