#include <vector>
#include <iostream>
#define int long long

using namespace std;

using row = std::vector<int>;
using Gex = std::vector<row>;

void _t(row &r) {
    for (int i = 0; i < r.size() / 2; i++) {
        swap(r[i], r[r.size() - 1 - i]);
    }
}

void t(Gex &g) {
    for (auto&& i : g) {
        _t(i);
    }
}

void _print(const row &r) {
    for (int i : r) {
        cout << i << " ";
    }
    cout << "\n";
}

void print(const Gex &g) {
    for (auto&& i : g) {
        _print(i);
    }
}

Gex init(int n);

Gex lt(const Gex &g) {
    int n = (g.size() + 1) / 2;
    Gex res = init(n);
    int rows = 2 * n - 1;

    for (int i = 0; i < rows; ++i) {
        for (int j = 0; j < (int)g[i].size(); ++j) {
            int x = j - max(0LL, i - (n - 1));
            int y = (n - 1) - i;
            int z = -x - y;

            int nx = z, ny = x, nz = y;

            int ni = n - 1 - ny;
            int nj = nx + max(0LL, ni - (n - 1));

            res[ni][nj] = g[i][j];
        }
    }

    return res;
}

Gex rt(Gex &g) {
    Gex n = g;
    for (int i = 0; i < 5; i++) {
        n = lt(n);
    }
    return n;
}

void _read(row& r) {
    for (int i = 0; i < r.size(); i++) {
        cin >> r[i];
    }
}

Gex init(int n) {
    Gex g;
    int rows = 2 * n - 1;
    for (int i = 0; i < rows / 2 + 1; i++) {
        row r(n + i);
        g.push_back(std::move(r));
    }
    for (int i = rows / 2 - 1; i >= 0; i--) {
        row r(n + i);
        g.push_back(std::move(r));
    }
    return g;
}

Gex read(int n) {
    Gex g = init(n);
    for (auto&& i : g) {
        _read(i);
    }
    return g;
}

signed main() {
    int n;
    cin >> n;
    Gex g = read(n);
    while (true) {
        char c;
        cin >> c;
        switch (c) {
            case 'L':
                g = lt(g);
                break;
            case 'R':
                g = rt(g);
                break;
            case 'T':
                t(g);
                break;
            default:
                goto br;
        }
    }
    br:
    print(g);
    return 0;
}