#include <bits/stdc++.h>

using namespace std;

random_device dev;
mt19937 rng(dev());
uniform_int_distribution<int> uid(0, 1);

//#define int long long
using ld = long double;
using ll = long long;

constexpr ll mod = 1e9 + 7;

#define forn(i, n) for (ll i = 0; i < (n); ++i)

struct pair_hash {
    template <class T1, class T2>
    std::size_t operator()(const std::pair<T1, T2> &p) const {
        auto h1 = std::hash<T1>{}(p.first);
        auto h2 = std::hash<T2>{}(p.second);
        return h1 ^ h2;
    }
};

void solve() {

    auto cost_of = [](ll x) {
        ll ans = 0;

        ll v = 1;
        while (x) {
            ++ans;
            x /= 10;
        }
        return ans;
    };

    auto simulate_collatz = [&cost_of](ll x) {
        ll ans = 0;
        while (x > 1) {
            if (ans > 600) {
                return ans;
            }

            if ((x & 1) == 0) {
                x /= 2;
            } else {
                x = 3 * x + 1;
            }
            ans += cost_of(x);
        }
        return ans;
    };

    //
    ll ans = 0;
    auto collatz = [&cost_of, &ans](ll x) {
        cout << "collatz" << endl;
        ll y;
        cin >> y;
        ans += cost_of(y);
        return y;
    };

    auto random = [&cost_of, &ans](ll x) {
        cout << "random" << endl;
        ll y;
        cin >> y;
        ans += cost_of(y);
        return y;
    };

    //
    ll x;
    cin >> x;

    ll in_a_row = 0;
    while (x > 1) {
        if (ans + simulate_collatz(x) > 600) {
            if (++in_a_row > 3) {
                forn(i, 3) { x = collatz(x); }
            } else {
                x = random(x);
                ++in_a_row;
            }
        } else {
            // fast path
            while (x > 1) {
                x = collatz(x);
            }
        }
    }
}

signed main() {
    int t = 1; cin >> t;
    while (t--) {
        solve();
    }
}
