#include <bits/stdc++.h>

using namespace std;

random_device dev;
mt19937 rng(dev());
uniform_int_distribution<int> uid(0, 1);

#define int long long
using ld = long double;
using ll = long long;

constexpr ll mod = 1e9 + 7;

#define forn(i, n) for (ll i = 0; i < (n); ++i)
#define all(a) begin(a), end(a)

struct pair_hash {
    template <class T1, class T2>
    std::size_t operator()(const std::pair<T1, T2> &p) const {
        auto h1 = std::hash<T1>{}(p.first);
        auto h2 = std::hash<T2>{}(p.second);
        return h1 ^ h2;
    }
};

using point = pair<int, int>;
ostream &operator<<(ostream &os, point p) {
    return os << p.first << " " << p.second;
}

int fast_multiply(int a, int b) {
    return (a * b) % mod;
}

int fast_power(int base, int exponent) {
    int result = 1;
    base = base % mod;
    while (exponent > 0) {
        if (exponent % 2 == 1) {
            result = fast_multiply(result, base);
        }
        exponent = exponent >> 1;
        base = fast_multiply(base, base);
    }
    return result;
}

pair<int, int> Euclid(int a, int b) {
    if (!b)
        return {1, 0};
    auto [x, y] = Euclid(b, a % b);
    return {y, x - y * (a / b)};
}

int mod_inverse(int a) {
    auto [x, y] = Euclid(a, mod);
    return (a * x + mod * y != 1 ? -1 : (x + mod) % mod);
}

int mod_divide(int a, int b) {
    a = a % mod;
    int inv = mod_inverse(b);
    return fast_multiply(inv, a);
}

void solve() {
    int p, m;
    cin >> p >> m;
    vector<int> probs(p);
    probs[0] = mod_inverse(2*p-1);
    for (int i = 1; i < p; i++) {
        probs[i] = fast_multiply(probs[i-1], 2 * (p-i));
        probs[i] = fast_multiply(probs[i], mod_inverse(2*p-(i+1)));
    }
    int mat = 0;
    for (int i = 0; i < p; i++) {
        mat += fast_multiply(i+2, fast_multiply(i+1, probs[i]));
        mat %= mod;
    }
    int ans = mat + fast_multiply(mat, fast_multiply(m, mod_inverse(2*p+1)));
    ans %= mod;
    cout << ans << '\n';
}


signed main() {
    int t = 1; cin >> t;
    while (t--) {
        solve();
    }
}