def can_play(sequence):
    # Соседние ноты на клавиатуре (белые и черные клавиши)
    # Включая саму ноту (можно оставаться на той же клавише)
    neighbors = {
        'A': {'A', 'B', 'G'},
        'B': {'B', 'A', 'C'},
        'C': {'C', 'B', 'D'},
        'D': {'D', 'C', 'E'},
        'E': {'E', 'D', 'F'},
        'F': {'F', 'E', 'G'},
        'G': {'G', 'F', 'A'}
    }

    for i in range(len(sequence) - 1):
        current_note = sequence[i]
        next_note = sequence[i + 1]

        if next_note not in neighbors[current_note]:
            return "No"

    return "Yes"


def main():
    t = int(input())
    results = []

    for _ in range(t):
        s = input().strip()
        if len(s) == 1:
            results.append("Yes")
        else:
            results.append(can_play(s))

    for result in results:
        print(result)


if __name__ == "main":
    main()