﻿#include <iostream>
#include <vector>
#include <string>
#include <unordered_map>
#include <set>

using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    unordered_map<char, int> note_to_num = {
        {'A', 0}, {'B', 1}, {'C', 2}, {'D', 3},
        {'E', 4}, {'F', 5}, {'G', 6}
    };

    vector<vector<int>> positions(7);
    for (int key = 0; key < 52; ++key) {
        positions[key % 7].push_back(key);
    }

    while (t--) {
        string melody;
        cin >> melody;
        int n = melody.size();

        vector<set<int>> dp(n);

        int first_note = note_to_num[melody[0]];
        for (int pos : positions[first_note]) {
            dp[0].insert(pos);
        }

        bool possible = true;
        for (int i = 1; i < n; ++i) {
            int note = note_to_num[melody[i]];

            for (int prev_pos : dp[i - 1]) {
                for (int new_pos : positions[note]) {
                    if (abs(new_pos - prev_pos) <= 3) {
                        dp[i].insert(new_pos);
                    }
                }
            }

            if (dp[i].empty()) {
                possible = false;
                break;
            }
        }

        cout << (possible ? "YES" : "NO") << endl;
    }

    return 0;
}