﻿#include <iostream>
#include <vector>
#include <unordered_map>
#include <unordered_set>
using namespace std;

int main() {
    ios::sync_with_stdio(false);

    int first;
    cin >> first;
    int n;
    cin >> n;
    vector<int> cards(n);
    for (int i = 0; i < n; ++i) cin >> cards[i];

    if (first == 0) {
        unordered_map<int, int> freq;
        for (int x : cards)
            freq[x]++;

        for (int i = 1; i < n; ++i) {
            if (freq[cards[i]] == 1) {
                cout << (i + 1) << "\n";
                return 0;
            }
        }

        cout << 1 << "\n";
    }
    else {
        unordered_set<int> seen(cards.begin(), cards.end());
        for (int x = 1; x <= n; ++x) {
            if (seen.find(x) == seen.end()) {
                cout << x << "\n";
                return 0;
            }
        }
        cout << 1 << "\n";
    }

    return 0;
}