#pragma GCC optimize("O3")
#pragma GCC optimize("unroll-loops")
#include <iostream>
#include <string>
#include <climits>
#include <vector>
#include <cmath>
#include <algorithm>


using namespace std;

const int MOD = 1'000'000'007;

long long mod_pow(long long a, long long b) {
    long long res = 1;
    a %= MOD;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

long long mod_inverse(long long n) {
    return mod_pow(n, MOD - 2);
}

long long solve(long long p, long long m) {
    long long t1 = (p + 1) % MOD;

    long long num = (2LL * p) % MOD;
    num = (num * m) % MOD;
    long long inv = mod_inverse(2LL * p + 1);
    long long t = (num * inv) % MOD;
    long long E = (t1 + t) % MOD;

    return E;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t;
    cin >> t;
    while (t--) {
        long long p, m;
        cin >> p >> m;
        cout << solve(p, m) << endl;
    }
    return 0;
}
