#include <bits/stdc++.h>
using namespace std;

static inline bool is_one(const string& s){ return s=="1"; }
static inline bool is_even(const string& s){ return ((s.back()-'0') & 1) == 0; }
static inline int digits(const string& s){ return (int)s.size(); }

static unsigned v2_cap(const string& s, unsigned cap){
    unsigned M = 1u << cap, rem = 0;
    for(char c: s) rem = (rem * 10u + (unsigned)(c - '0')) % M;
    if(rem == 0) return cap;
    unsigned k = 0;
    while(k < cap && ((rem >> k) & 1u) == 0u) ++k;
    return k;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    const int MAX_GLOBAL_BLUES = 12;
    const int MAX_BLUES_PER_ROUND = 2;
    const int MAX_BLUE_LEN = 6;
    const unsigned ACCEPT_V2 = 8;
    const int ROUND_SOFT_CAP = 620;
    const double AHEAD_AVG = 590.0;

    long long total_spent = 0;
    int global_blues_used = 0;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        int round_spent = 0;
        int blues_this_round = 0;

        while(true){
            if(is_one(x)) break;

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                int d = digits(x);
                total_spent += d; round_spent += d;
                continue;
            }

            double avg_so_far = (round == 0 ? 0.0 : (double)total_spent / round);
            bool can_blue_global = global_blues_used < MAX_GLOBAL_BLUES;
            bool can_blue_round  = blues_this_round < MAX_BLUES_PER_ROUND && round_spent < ROUND_SOFT_CAP;
            bool size_ok         = digits(x) <= MAX_BLUE_LEN;
            bool on_pace         = avg_so_far <= AHEAD_AVG;

            bool try_blue = can_blue_global && can_blue_round && size_ok && !on_pace;

            if(try_blue){
                int len_before = digits(x);
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                int d = digits(x);
                total_spent += d; round_spent += d;
                ++global_blues_used; ++blues_this_round;

                if(is_one(x)) continue;

                if(d - len_before >= 2){
                } else {
                    unsigned v = v2_cap(x, 12);
                    if(v >= ACCEPT_V2){
                        while(!is_one(x) && is_even(x)){
                            cout << "collatz\n" << flush;
                            if(!(cin >> x)) return 0;
                            if(x == "0") return 0;
                            int dd = digits(x);
                            total_spent += dd; round_spent += dd;
                        }
                        continue;
                    }
                }
            }

            cout << "collatz\n" << flush;
            if(!(cin >> x)) return 0;
            if(x == "0") return 0;
            {
                int d = digits(x);
                total_spent += d; round_spent += d;
            }
            while(!is_one(x) && is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                int d = digits(x);
                total_spent += d; round_spent += d;
            }
        }
    }
    return 0;
}
