#include <bits/stdc++.h>
using namespace std;

static const int P = 999983;
static const int A = 618023;

struct Bitset {
    int n;
    vector<unsigned long long> w;
    unsigned long long last_mask;

    Bitset(int n_): n(n_) {
        int m = (n + 63) >> 6;
        w.assign(m, 0);
        int r = n & 63;
        last_mask = (r == 0) ? ~0ull : ((1ull << r) - 1);
    }

    inline int words() const { return (int)w.size(); }

    inline bool get(int i) const {
        return (w[i>>6] >> (i&63)) & 1ull;
    }

    inline void xor_bit(int i) {
        w[i>>6] ^= (1ull << (i & 63));
        if ((i>>6) == words()-1) w.back() &= last_mask;
    }

    inline void set1(int i) {
        w[i>>6] |= (1ull << (i & 63));
        if ((i>>6) == words()-1) w.back() &= last_mask;
    }

    void xor_shl(const Bitset& other, int shift) {
        if (shift >= n) return;
        int ws = shift >> 6;
        int rs = shift & 63;
        int m = other.words();
        int M = words();

        if (rs == 0) {
            for (int i = 0; i < m; ++i) {
                int j = i + ws;
                if (j < M) w[j] ^= other.w[i];
            }
        } else {
            for (int i = 0; i < m; ++i) {
                int j = i + ws;
                unsigned long long lo = other.w[i] << rs;
                if (j < M) w[j] ^= lo;
                if (j+1 < M) {
                    unsigned long long hi = other.w[i] >> (64 - rs);
                    w[j+1] ^= hi;
                }
            }
        }
        w.back() &= last_mask;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    long long n, s;
    if (!(cin >> n >> s)) {
        cout << 0 << "\n";
        return 0;
    }

    Bitset B(P), S(P);
    long long cnt = 0;

    for (long long step = 0; step < n; ++step) {
        if (step == 0) s = (s * A + 1) % P;

        bool inB = B.get((int)s);
        if (step < 2) {
            if (!inB) {
                S.xor_shl(B, (int)s);
                int t2 = (int)(s + s);
                if (t2 < P) S.xor_bit(t2);
                B.set1((int)s);
                ++cnt;
            }
        } else {
            if (!S.get((int)s) && !inB) {
                S.xor_shl(B, (int)s);
                int t2 = (int)(s + s);
                if (t2 < P) S.xor_bit(t2);
                B.set1((int)s);
                ++cnt;
            }
        }
        s = (s * A + 1) % P;
    }

    cout << cnt << "\n";
    return 0;
}
