def optimal_split(arr):
    total = sum(arr)
    target = total // 2
    
    dp = [False] * (target + 1)
    dp[0] = True
    
    for num in arr:
        for j in range(target, num - 1, -1):
            if dp[j - num]:
                dp[j] = True
    
    for i in range(target, -1, -1):
        if dp[i]:
            return i, total - i
    
    return 0, total

n = int(input())
nums = list(map(int, input().split()))
nums.sort()
least = nums[0] * sum(nums[1:])
sum1, sum2 = optimal_split(nums)
huge = sum1 * sum2

print(least, huge)