import java.io.BufferedInputStream
import java.io.PrintWriter

private class FastScanner {
    private val input = BufferedInputStream(System.`in`)
    private val buffer = ByteArray(1 shl 16)
    private var len = 0
    private var ptr = 0

    private fun readByte(): Int {
        if (ptr >= len) {
            len = input.read(buffer)
            ptr = 0
            if (len < 0) return -1
        }
        return buffer[ptr++].toInt()
    }

    fun nextLong(): Long {
        var c = readByte()
        while (c <= 32 && c >= 0) c = readByte()
        var sign = 1
        if (c == '-'.code) {
            sign = -1
            c = readByte()
        }
        var res = 0L
        while (c > 32) {
            res = res * 10 + (c - '0'.code)
            c = readByte()
        }
        return if (sign == 1) res else -res
    }
}

fun main() {
    val fs = FastScanner()
    var cur = fs.nextLong()
    var steps = 0
    while (cur > 0) {
        val bin = java.lang.Long.toBinaryString(cur)
        val rev = bin.reversed()
        val afterFlip = java.lang.Long.parseLong(rev, 2)
        cur = afterFlip - 1
        steps++
    }
    val out = PrintWriter(System.out)
    out.println(steps)
    out.flush()
}
