import sys
input = sys.stdin.readline

def mex_from_counts(missing, cur_mex):
    while cur_mex in missing and missing[cur_mex] == 0:
        cur_mex += 1
    return cur_mex

def solve_first(a):
    n = len(a)
    b = a + a

    freq = [0] * (n + 2)
    for i in range(n - 1):
        v = b[i + 1]
        freq[v] += 1

    missing_count = [0] * (n + 2)
    for v in range(1, n + 2):
        if freq[v] == 0:
            missing_count[v] = 1

    cur_mex = 1
    while cur_mex <= n + 1 and missing_count[cur_mex] == 0:
        cur_mex += 1

    need_mex = [0] * n
    need_mex[0] = cur_mex

    for i in range(1, n):
        out_v = b[i]
        freq[out_v] -= 1
        if freq[out_v] == 0:
            missing_count[out_v] = 1

        in_v = b[i + n - 1]
        prev = freq[in_v]
        freq[in_v] += 1
        if prev == 0:
            missing_count[in_v] = 0

        while cur_mex <= n + 1 and missing_count[cur_mex] == 0:
            cur_mex += 1
        need_mex[i] = cur_mex

    best_idx = 0
    best_val = -1
    for i in range(n):
        if need_mex[i] == a[i]:
            if a[i] > best_val:
                best_val = a[i]
                best_idx = i

    return best_idx + 1

def solve_second(vis):
    s = set(vis)
    x = 1
    while x in s:
        x += 1
    return x

mode = int(input().strip())
m = int(input().strip())
arr = list(map(int, input().split()))

if mode == 0:
    ans = solve_first(arr)
    print(ans)
else:
    ans = solve_second(arr)
    print(ans)
