import java.io.*;
import java.util.*;

public class gex {
    static class FastScanner {
        private final InputStream in;
        private final byte[] buffer = new byte[1 << 16];
        private int ptr = 0, len = 0;
        FastScanner(InputStream is) { in = is; }
        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buffer);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buffer[ptr++];
        }
        int nextInt() throws IOException {
            int c;
            do c = read(); while (c <= ' ' && c != -1);
            int sgn = 1;
            if (c=='-') { sgn = -1; c = read(); }
            int x = 0;
            while (c > ' ') {
                x = x*10 + (c-'0');
                c = read();
            }
            return x*sgn;
        }
        String next() throws IOException {
            int c;
            do c = read(); while (c <= ' ' && c != -1);
            StringBuilder sb = new StringBuilder();
            while (c > ' ') {
                sb.append((char)c);
                c = read();
            }
            return sb.toString();
        }
    }

    static long pack(int x,int y,int z){
        long X = x & 0xffffffffL;
        long Y = y & 0xffffffffL;
        long Z = z & 0xffffffffL;
        return (X<<42) ^ (Y<<21) ^ Z;
    }

    public static void main(String[] args) throws Exception {
        FastScanner fs = new FastScanner(System.in);
        int n = fs.nextInt();
        int R = n-1;
        int rows = 2*n-1;

        int totalCells = 0;
        for (int row=0; row<rows; row++) {
            int lenRow = (row < n ? n+row : 3*n-2-row);
            totalCells += lenRow;
        }

        int[] vx = new int[totalCells];
        int[] vy = new int[totalCells];
        int[] vz = new int[totalCells];
        int[] vv = new int[totalCells];

        int ptr = 0;
        for (int row=0; row<rows; row++) {
            int y = R - row;
            int xMin = Math.max(-R, -R - y);
            int xMax = Math.min(R,  R - y);
            for (int x=xMin; x<=xMax; x++) {
                int z = -x - y;
                int val = fs.nextInt();
                vx[ptr] = x;
                vy[ptr] = y;
                vz[ptr] = z;
                vv[ptr] = val;
                ptr++;
            }
        }

        String ops = fs.next();

        int ix = 0, iy = 1, iz = 2;

        for (int i=0; i<ops.length(); i++) {
            char c = ops.charAt(i);
            if (c == 'R') {
                int nix = iy, niy = iz, niz = ix;
                ix = nix; iy = niy; iz = niz;
            } else if (c == 'L') {
                int nix = iz, niy = ix, niz = iy;
                ix = nix; iy = niy; iz = niz;
            } else {
                int nix = ix, niy = iz, niz = iy;
                ix = nix; iy = niy; iz = niz;
            }
        }

        HashMap<Long,Integer> finalMap = new HashMap<>(totalCells*2);

        for (int i=0; i<totalCells; i++) {
            int x = vx[i], y = vy[i], z = vz[i];
            int[] arr = {x,y,z};
            int X = arr[ix];
            int Y = arr[iy];
            int Z = arr[iz];
            long k = pack(X,Y,Z);
            finalMap.put(k, vv[i]);
        }

        StringBuilder sb = new StringBuilder();
        for (int row=0; row<rows; row++) {
            int y = R - row;
            int xMin = Math.max(-R, -R - y);
            int xMax = Math.min(R,  R - y);
            boolean first = true;
            for (int x=xMin; x<=xMax; x++) {
                int z = -x - y;
                long k = pack(x,y,z);
                int val = finalMap.get(k);
                if (!first) sb.append(' ');
                first = false;
                sb.append(val);
            }
            sb.append('\n');
        }

        System.out.print(sb.toString());
    }
}
