import java.io.*;

public class Kolatz {
    public static void main(String[] args) throws Exception {
        FastIO io = new FastIO(System.in, System.out);
        int tests = io.nextInt();
        for (int i = 0; i < tests; i++) {
            String currentValue = io.nextToken();
            while (true) {
                if (currentValue.equals("0")) {
                    io.out.flush();
                    return;
                }
                if (currentValue.equals("1")) {
                    break;
                }

                boolean useRandom = false;
                int parityLastDigit = currentValue.charAt(currentValue.length() - 1) - '0';
                boolean isEven = (parityLastDigit % 2 == 0);

                long numericValue = parseUpToLong(currentValue);
                boolean isBigNumber = numericValue == -1L || numericValue > 1_000_000_000_000L;

                if (!isEven && !isBigNumber && numericValue < 1000L) {
                    useRandom = true;
                }

                if (useRandom) {
                    io.println("random");
                } else {
                    io.println("collatz");
                }
                io.flushOutput();

                currentValue = io.nextToken();
            }
        }
        io.out.flush();
    }

    private static long parseUpToLong(String s) {
        if (s.length() > 18) return -1L;
        long v = 0L;
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') return -1L;
            int d = c - '0';
            if (v > Long.MAX_VALUE / 10L) return -1L;
            v = v * 10L;
            long add = d;
            if (v > Long.MAX_VALUE - add) return -1L;
            v += add;
        }
        return v;
    }

    private static class FastIO {
        private final InputStream in;
        public final PrintWriter out;
        private final byte[] buffer = new byte[1 << 16];
        private int bufferSize = 0;
        private int bufferIndex = 0;
        private final StringBuilder tokenBuilder = new StringBuilder();

        FastIO(InputStream is, OutputStream os) {
            in = is;
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        }

        String nextToken() throws IOException {
            tokenBuilder.setLength(0);
            int c;
            while (true) {
                c = read();
                if (c == -1) return "0";
                if (!isSpace(c)) break;
            }
            while (c != -1 && !isSpace(c)) {
                tokenBuilder.append((char) c);
                c = read();
            }
            return tokenBuilder.toString();
        }

        int nextInt() throws IOException {
            return Integer.parseInt(nextToken());
        }

        private boolean isSpace(int c) {
            return c == ' ' || c == '\n' || c == '\r' || c == '\t';
        }

        private int read() throws IOException {
            if (bufferIndex >= bufferSize) {
                bufferSize = in.read(buffer);
                bufferIndex = 0;
                if (bufferSize <= 0) return -1;
            }
            return buffer[bufferIndex++];
        }

        void println(String s) {
            out.println(s);
        }

        void flushOutput() {
            out.flush();
        }
    }
}
