import sys

MOD = 10**9 + 7

data = sys.stdin.read().strip().split()
t = int(data[0])
pairs = []
pos = 1
max_p = 0
for _ in range(t):
    p = int(data[pos]); m = int(data[pos+1])
    pos += 2
    pairs.append((p, m))
    if p > max_p:
        max_p = p

lim = 2 * max_p + 1
inv = [0] * (lim + 1)
inv[1] = 1
for i in range(2, lim + 1):
    inv[i] = MOD - (MOD // i) * inv[MOD % i] % MOD

base = [0] * (max_p + 1)
base[0] = 1
for p in range(0, max_p):
    num = (2 * (p + 1)) % MOD
    den_inv = inv[2 * p + 1]
    base[p + 1] = base[p] * num % MOD * den_inv % MOD

out = []
for p, m in pairs:
    top = (m + 2 * p + 1) % MOD
    ans = base[p] * top % MOD
    ans = ans * inv[2 * p + 1] % MOD
    out.append(str(ans))

sys.stdout.write("\n".join(out))
