#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX_N = 3000005; // 2*10^6 + 10^6 + запас

long long modpow(long long a, long long b) {
    long long res = 1;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

vector<long long> fact, inv_fact;

void precompute(int n) {
    fact.resize(n + 1);
    inv_fact.resize(n + 1);
    fact[0] = 1;
    for (int i = 1; i <= n; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    inv_fact[n] = modpow(fact[n], MOD - 2);
    for (int i = n - 1; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }
}

long long comb(int n, int k) {
    if (k < 0 || k > n) return 0;
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    precompute(MAX_N - 1);

    int t;
    cin >> t;

    while (t--) {
        int p, m;
        cin >> p >> m;
        int N = 2 * p + m;

        // Предподсчёт степеней 2
        vector<long long> pow2(p + 1);
        pow2[0] = 1;
        for (int i = 1; i <= p; i++) {
            pow2[i] = pow2[i - 1] * 2 % MOD;
        }

        long long ans = 0;

        // E = sum_{k=0..N-1} P(X > k)
        for (int k = 0; k < N; k++) {
            long long good = 0;
            for (int i = 0; i <= min(p, k); i++) {
                if (k - i > m) continue;
                good = (good + comb(p, i) * pow2[i] % MOD * comb(m, k - i)) % MOD;
            }
            long long total = comb(N, k);
            ans = (ans + good * modpow(total, MOD - 2)) % MOD;
        }

        cout << ans << '\n';
    }

    return 0;
}
