#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX = 3000005;

long long modpow(long long a, long long b) {
    long long res = 1;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

vector<long long> fact, inv_fact;

void precompute() {
    fact.resize(MAX);
    inv_fact.resize(MAX);
    fact[0] = 1;
    for (int i = 1; i < MAX; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    inv_fact[MAX - 1] = modpow(fact[MAX - 1], MOD - 2);
    for (int i = MAX - 2; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }
}

long long comb(int n, int k) {
    if (k < 0 || k > n) return 0;
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    precompute();

    int t;
    cin >> t;

    while (t--) {
        int p, m;
        cin >> p >> m;

        // Используем известную формулу для этой задачи
        // E = 1 + 2p/(m + 2)
        long long numerator = (m + 2 + 2LL * p) % MOD;
        long long denominator = (m + 2) % MOD;
        long long ans = numerator * modpow(denominator, MOD - 2) % MOD;

        cout << ans << '\n';
    }

    return 0;
}
