import sys

MOD = 10**9 + 7

def pre_calc(n):
    fact = [1] * (n + 1)
    inv_fact = [1] * (n + 1)
    for i in range(1, n + 1):
        fact[i] = fact[i - 1] * i % MOD
    inv_fact[n] = pow(fact[n], MOD - 2, MOD)
    for i in range(n, 0, -1):
        inv_fact[i - 1] = inv_fact[i] * i % MOD
    return fact, inv_fact

max_n = 2000000
fact, inv_fact = pre_calc(max_n)

def nCr(n, r):
    if r < 0 or r > n:
        return 0
    return fact[n] * inv_fact[r] % MOD * inv_fact[n - r] % MOD

t = int(input())
for _ in range(t):
    p, m = map(int, input().split())
    val = (2 * p + m + 1) % MOD * pow(4, p, MOD) % MOD
    kol = (2 * p + 1) % MOD * nCr(2 * p, p) % MOD
    ans = val * pow(kol, MOD - 2, MOD) % MOD
    print(ans)
    
