#include <algorithm>
#include <iostream>
#include <string>
#include <unordered_map>
#include <vector>

typedef long long ll;

struct Coord {
  int x, y, z;
};

ll encode(int x, int y, int z) {
  static const int SHIFT = 600;
  static const int BASE = 2 * SHIFT + 1;
  return (static_cast<ll>(x + SHIFT) * BASE + (y + SHIFT)) * BASE + (z + SHIFT);
}

int main() {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);

  int n;
  std::cin >> n;
  int r = n - 1;

  std::vector<Coord> order;
  order.reserve(1 + 3LL * r * (r + 1));
  for (int z = r; z >= -r; --z) {
    int xmin = std::max(-r, -r - z);
    int xmax = std::min(r, r - z);
    for (int x = xmin; x <= xmax; ++x) {
      int y = -x - z;
      order.push_back({x, y, z});
    }
  }

  std::vector<std::string> vals(order.size());
  for (size_t i = 0; i < vals.size(); ++i) {
    std::cin >> vals[i];
  }

  std::string ops;
  std::cin >> ops;

  int idx[3] = {0, 1, 2};
  int sgn[3] = {1, 1, 1};

  auto apply_transform = [&](const int *t_idx, const int *t_sgn) {
    int next_idx[3];
    int next_sgn[3];
    for (int k = 0; k < 3; ++k) {
      next_idx[k] = idx[t_idx[k]];
      next_sgn[k] = t_sgn[k] * sgn[t_idx[k]];
    }
    for (int k = 0; k < 3; ++k) {
      idx[k] = next_idx[k];
      sgn[k] = next_sgn[k];
    }
  };

  const int T_IDX[3] = {1, 0, 2};
  const int T_SGN[3] = {1, 1, 1};
  const int L_IDX[3] = {2, 0, 1};
  const int L_SGN[3] = {-1, -1, -1};
  const int R_IDX[3] = {1, 2, 0};
  const int R_SGN[3] = {-1, -1, -1};

  for (char c : ops) {
    if (c == 'T') {
      apply_transform(T_IDX, T_SGN);
    } else if (c == 'L') {
      apply_transform(L_IDX, L_SGN);
    } else if (c == 'R') {
      apply_transform(R_IDX, R_SGN);
    }
  }

  std::unordered_map<ll, size_t> index_by_coord;
  index_by_coord.reserve(order.size() * 2);
  for (size_t i = 0; i < order.size(); ++i) {
    index_by_coord[encode(order[i].x, order[i].y, order[i].z)] = i;
  }

  std::vector<std::string> out(order.size());
  for (size_t i = 0; i < order.size(); ++i) {
    int coord[3] = {order[i].x, order[i].y, order[i].z};
    int nx = sgn[0] * coord[idx[0]];
    int ny = sgn[1] * coord[idx[1]];
    int nz = sgn[2] * coord[idx[2]];
    out[index_by_coord[encode(nx, ny, nz)]] = vals[i];
  }

  size_t p = 0;
  for (int z = r; z >= -r; --z) {
    int xmin = std::max(-r, -r - z);
    int xmax = std::min(r, r - z);
    for (int x = xmin; x <= xmax; ++x) {
      if (x > xmin) {
        std::cout << ' ';
      }
      std::cout << out[p++];
    }
    std::cout << '\n';
  }

  return 0;
}
