import sys
input = sys.stdin.readline

def matmul(a, b):
    return [
        [
            a[i][0]*b[0][j] + a[i][1]*b[1][j] + a[i][2]*b[2][j]
            for j in range(3)
        ]
        for i in range(3)
    ]

n = int(input())
grid_values_flat = []
for _ in range(2 * n - 1):
    grid_values_flat.extend(map(int, input().split()))
ops = input().strip()

m_r = [[0, 0, -1], [-1, 0, 0], [0, -1, 0]]
m_l = [[0, -1, 0], [0, 0, -1], [-1, 0, 0]]
m_t = [[0, 1, 0], [1, 0, 0], [0, 0, 1]]

m = [[1, 0, 0], [0, 1, 0], [0, 0, 1]]
for c in ops:
    if c == 'R':
        m = matmul(m_r, m)
    elif c == 'L':
        m = matmul(m_l, m)
    elif c == 'T':
        m = matmul(m_t, m)

coords = []
vals = []
idx = 0
for i in range(2 * n - 1):
    r = i - (n - 1)
    q_min = max(-(n - 1), -r - (n - 1))
    q_max = min((n - 1), -r + (n - 1))
    for q in range(q_min, q_max + 1):
        x = q
        z = r
        y = -x - z
        coords.append((x, y, z))
        vals.append(grid_values_flat[idx])
        idx += 1

pos_map = {}
for i in range(len(coords)):
    x, y, z = coords[i]
    x2 = m[0][0]*x + m[0][1]*y + m[0][2]*z
    y2 = m[1][0]*x + m[1][1]*y + m[1][2]*z
    z2 = m[2][0]*x + m[2][1]*y + m[2][2]*z
    pos_map[(x2, y2, z2)] = vals[i]

out = []
for i in range(2 * n - 1):
    r = i - (n - 1)
    q_min = max(-(n - 1), -r - (n - 1))
    q_max = min((n - 1), -r + (n - 1))
    row = []
    for q in range(q_min, q_max + 1):
        x = q
        z = r
        y = -x - z
        row.append(str(pos_map[(x, y, z)]))
    out.append(" ".join(row))

sys.stdout.write("\n".join(out))