#include <bits/stdc++.h>
// #pragma comment(linker, "/STACK:16777216")
// #pragma GCC optimize("O3,unroll-loops")
// #pragma GCC target("avx2,sse4,fma,bmi,bmi2,popcnt,lzcnt,abm,tune=native")

using namespace std;
using ll = long long;
using dbl = double;
using ld = long double;
using vll = vector<ll>;
using pi = pair<ll, ll>;
using pll = pair<ll, ll>;
using pd = pair<dbl, dbl>;
using pld = pair<ld, ld>;

#define ft first
#define sc second
#define pb push_back
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()

struct Mat {
    ll a11, a12, a21, a22;
};

static inline Mat mul(const Mat &A, const Mat &B) {
    return {
            A.a11 * B.a11 + A.a12 * B.a21,
            A.a11 * B.a12 + A.a12 * B.a22,
            A.a21 * B.a11 + A.a22 * B.a21,
            A.a21 * B.a12 + A.a22 * B.a22};
}

void solve() {
    ll n;
    cin >> n;
    ll R = n - 1;
    ll rows = 2 * n - 1;

    vector<vll> a(rows);
    for (ll i = 0; i < rows; ++i) {
        ll r = -R + i;
        ll len = 2 * R - abs(r) + 1;
        a[i].resize(len);
        for (ll j = 0; j < len; ++j) cin >> a[i][j];
    }

    string ops;
    cin >> ops;

    Mat I{1, 0, 0, 1};
    Mat M_R{0, -1, 1, 1};
    Mat M_L{1, 1, -1, 0};
    Mat M_T{-1, -1, 0, 1};

    Mat M = I;
    for (char ch: ops) {
        if (ch == 'R') M = mul(M_R, M);
        else if (ch == 'L')
            M = mul(M_L, M);
        else if (ch == 'T')
            M = mul(M_T, M);
    }

    vector<vll> out(rows);
    for (ll i = 0; i < rows; ++i) {
        ll r = -R + i;
        ll len = 2 * R - abs(r) + 1;
        out[i].assign(len, 0);
    }

    auto qmin_for_r = [&](ll r) -> ll {
        return max(-R, -r - R);
    };

    for (ll i = 0; i < rows; ++i) {
        ll r = -R + i;
        ll len = a[i].size();
        ll qmin = qmin_for_r(r);
        for (ll j = 0; j < len; ++j) {
            ll q = qmin + j;

            ll qp = M.a11 * q + M.a12 * r;
            ll rp = M.a21 * q + M.a22 * r;

            ll rpi = rp;
            ll rowIdx = rpi + R;
            ll qminp = qmin_for_r(rpi);
            ll colIdx = qp - qminp;
            out[rowIdx][colIdx] = a[i][j];
        }
    }

    for (ll i = 0; i < rows; ++i) {
        for (ll j = 0; j < out[i].size(); ++j) {
            if (j) cout << ' ';
            cout << out[i][j];
        }
        cout << '\n';
    }
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    // freopen("", "r", stdin);
    // freopen("", "w", stdout);

    ll t = 1;
    // cin >> t;
    while (t--) solve();
    return 0;
}