from sys import stdout
 
from functools import lru_cache
 
@lru_cache(maxsize=None)
def collatz_cost(n, max_depth=128, current_depth=0):
    if current_depth >= max_depth:
        return 0
    if n == 1:
        return 1
    elif n % 2 == 0:
        next_n = n // 2
    else:
        next_n = 3 * n + 1
    return len(str(next_n)) + collatz_cost(next_n, max_depth, current_depth + 1)
 
t = int(input())
 
 
for i in range(t):
    n = int(input())
 
    cost = collatz_cost(n)
 
    while n != 1:
        while n % 2 == 0:
            print("collatz")
            stdout.flush()
            n = int(input())
            if n == 0:
                exit(0)
            
        if n == 1:
            break

        cost = collatz_cost(n)
        if cost < 300 or n >= 60000000:
            print("collatz")

        else:
            print("random")

        stdout.flush()
        n = int(input())
        if n == 0:
            exit(0)
