from sys import stdout
 

def count_digits(n):
    return len(str(n))

cost_cache = {}
 
def collatz_cost(n, max_depth=801):
    cost = 0
    current = n
    depth = 0
       
    while current != 1 and depth < max_depth:
        if current % 2 == 0:
            next_val = current // 2
        else:
            next_val = 3 * current + 1
           
        cost += count_digits(next_val)
        current = next_val
        depth += 1
           
        if current in cost_cache and depth < max_depth:
            cost += cost_cache[current]
            break
       
    if depth < max_depth:
        cost_cache[n] = cost
       
    return cost
 
t = int(input())
 
 
for i in range(t):
    n = int(input())
 
    cost = collatz_cost(n)
 
    while n != 1:
        while n % 2 == 0:
            print("collatz")
            stdout.flush()
            n = int(input())
            if n == 0:
                exit(0)
            
        if n == 1:
            break

        cost = collatz_cost(n)
        if cost < 800 or n >= 1000000:
            print("collatz")

        else:
            print("random")

        stdout.flush()
        n = int(input())
        if n == 0:
            exit(0)
