#include <bits/stdc++.h>
#define pb push_back
#define sz(x) (int)(x).size()
#define all(v) (v).begin(), (v).end()

using namespace std;
using ll = long long;
using ld = long double;

mt19937 rnd(chrono::steady_clock::now().time_since_epoch().count());

int col[1005][1005];
bool used[1005][1005];
vector<pair<int, int>> ans;

int ask(int x, int y)
{
    cout << "? " << x << " " << y << endl;
    char c;
    cin >> c;
    return (c == 'W');
}

int A, B;

bool check(int x, int y)
{
    return (1 <= x && x <= A && 1 <= y && y <= B && !used[x][y]);
}

void dfs(int x, int y)
{
    used[x][y] = 1;
    ans.pb({x, y});

    for (int dx = -1; dx <= 1; ++dx)
    {
        for (int dy = -1; dy <= 1; ++dy)
        {
            if (check(x + dx, y + dy))
            {
                dfs(x + dx, y + dy);
            }
        }
    }
}

void solve()
{
    int n;
    cin >> n;
    ans.clear();

    // int A = -1, B = -1;
    A = 2,
    B = n;
    // for (int i = 1; i * i <= 2 * n; ++i)
    // {
    //     if ((2 * n) % i == 0)
    //     {
    //         A = i;
    //         B = (2 * n) / i;
    //     }
    // }

    vector<pair<int, int>> vec;
    for (int i = 1; i <= A; ++i)
    {
        for (int j = 1; j <= B; ++j)
        {
            vec.pb({i, j});
            col[i][j] = -1;
            used[i][j] = 0;
        }
    }

    shuffle(all(vec), rnd);

    for (auto [x, y] : vec)
    {
        col[x][y] = ask(x, y);
    }

    for (int i = 1; i <= A; ++i)
    {
        for (int j = 1; j <= B; ++j)
        {
            if (!used[i][j])
            {
                ans.clear();
                dfs(i, j);

                if (sz(ans) >= n)
                {
                    cout << "! ";
                    if (col[i][j] == 1)
                        cout << "W ";
                    else
                        cout << "B ";
                    for (int i = 0; i < n; ++i)
                        cout << ans[i].first << " " << ans[i].second << " ";
                    return;
                }
            }
        }
    }

    assert(false);
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int tt;
    cin >> tt;
    while (tt--)
    {
        solve();
    }

    return 0;
}