// #pragma GCC optimize("Ofast,unroll-loops")
#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using ld = long double;
#define pb push_back
#define all(a) begin(a), end(a)
#define rall(a) a.rbegin(), a.rend()
#define pii pair<int, int>

mt19937 rng(chrono::steady_clock::now().time_since_epoch().count());
// uniform_int_distribution<long long> dist(0, 1e18);

const int mod = 1e9 + 7;
const int inf = 2e9 + 123;
const int N = 1000100;

vector<int> dx = {1, 1, 1, -1, -1, -1, 0, 0};
vector<int> dy = {1, 0, -1, 1, 0, -1, -1, 1};

int n;

int ask(int x, int y) {
    cout << "? " << x << ' ' << y << endl;
    char c;
    cin >> c;
    if(c == 'W') return 1;
    return 2;
}

int m;
int ax[1010];
int ay[1010];

int color;
map<pii, int> was;
map<pii, bool> saw;

void dfs(int x, int y) {
    saw[{x, y}] = 1;
    
    ax[m] = x;
    ay[m] = y;
    m++;

    if(m == n) {
        return;
    }
    
    vector<int> tmp;

    for(int i = 0; i < 8; ++i) {
        int nx = dx[i] + x;
        int ny = dy[i] + y;
        pii np = {nx, ny};

        if(!saw[np] && was[np] == color) {
            dfs(nx, ny);

            if(m == n) {
                return;
            }
        } else {
            tmp.push_back(i);
        }
    }

    if(tmp.empty()) return;
    random_shuffle(all(tmp));

    for(int &i : tmp) {
        int nx = dx[i] + x;
        int ny = dy[i] + y;
        pii np = {nx, ny};

        if(saw[np]) {
            continue;
        }

        if(!was[np]) {
            was[np] = ask(nx, ny);
        }
        if(color == was[np]) {
            dfs(nx, ny);

            if(m == n) {
                return;
            }
        }
    }
}

void solve() {
    cin >> n;

    uniform_int_distribution<int> dist(-100000, 100000);
    int sx = dist(rng);
    int sy = dist(rng);
    was[{sx, sy}] = ask(sx, sy);
    color = was[{sx, sy}];
    
    while(true) {
        m = 0;
        dfs(sx, sy);

        if(m == n) {
            char c = 'W';
            if(color == 2) {
                c = 'B';
            }
            cout << "! " << c;
            for(int i = 0; i < m; ++i) {
                cout << ' ' << ax[i] << ' ' << ay[i];
            }
            cout << endl;

            was.clear();
            saw.clear();
            return;
        } 

        if(color == 1) {
            color = 2;
        } else {
            color = 1;
        }

        while(was[{sx, sy}]) {
            sy--;
        }
        sy++;

        // assert(was[{sx, sy}] == color);
    }
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int T = 1;
    cin >> T;

    for (int i = 1; i <= T; i++) {
        solve();
        // cout << '\n';
    }
    // g++ -std=c++17 -fconcepts -Wall -Wextra -pedantic A.cpp && A < input.txt
}