import sys
from collections import deque

input_data = sys.stdin.read().splitlines()

t = int(input_data[0])
index = 1

for _ in range(t):
    n, m = map(int, input_data[index].split())
    index += 1

    adj = [[] for _ in range(n + 1)]
    for _ in range(m):
        u, v = map(int, input_data[index].split())
        adj[u].append(v)
        adj[v].append(u)
        index += 1

    color = [-1] * (n + 1)

    def bfs(start):
        queue = deque([start])
        color[start] = 0

        while queue:
            node = queue.popleft()

            for neighbor in adj[node]:
                if color[neighbor] == -1:
                    color[neighbor] = 1 - color[node]
                    queue.append(neighbor)
                elif color[neighbor] == color[node]:
                    return False
        return True

    possible = True
    for i in range(1, n + 1):
        if color[i] == -1:
            if not bfs(i):
                possible = False
                break

    if not possible:
        print(-1)
    else:
        result = [color[i] + 1 for i in range(1, n + 1)]
        print(" ".join(map(str, result)))
