#include <iostream>
#include <string>
#include <algorithm>
#include <cmath>
#include <vector>

long long int binToDec(std::string s){
	long long int result = 0;
	int twosS = 0;
	for(int i = s.size() - 1; i >= 0; --i){
		result += std::stoi(std::string() + s[i]) * std::pow(2, twosS);
		twosS++;
	}
	return result;
}

std::string decToBin(long long int n){
	std::string result = std::string();
	while(n > 1){
		if(n % 2 == 0){
			result.push_back('0');
		}else{
			result.push_back('1');
		}
		n /= 2;
	}
	result.push_back('1');
	
	std::reverse(result.begin(), result.end());
	return result;
}

std::vector<std::string> chunkingBySeven(std::string s){
	std::vector<std::string> result;
	std::string temp = "";
	int currentChunkSize = 0;
	int size = s.size();
	while(size % 7 != 0){
		size++;
	}
	temp.assign(size - s.size(), '0');
	currentChunkSize = size - s.size();
	for(int i = 0; i < s.size(); ++i){
		if(currentChunkSize == 7){
			result.push_back(temp);
			//std::cout << temp << std::endl;
			temp = "";
			currentChunkSize = 0;
		}
		temp.push_back(s[i]);
		currentChunkSize++;
	}
	result.push_back(temp);
	//std::cout << temp << std::endl;
	return result;
}

int main(){
	int n;
	std::cin >> n;
	if(n == 0){
		std::cout << 0;
		return 0;
	}
	std::vector<std::string> chunks = chunkingBySeven(decToBin(n));
	for(int i = 0; i < chunks.size(); ++i){
		if(i == chunks.size() - 1){
			std::cout << binToDec("0" + chunks[i]);
			return 0;
		}
		std::cout << binToDec("1" + chunks[i]) << ' ';
	}
}
