import java.io.*;
import java.util.*;
import java.util.Map.*;

public class Main {
	FastScanner in;
	PrintWriter out;
	boolean systemIO = true;

	int n;
	int INF = 40000;

	int[] dx = { -1, -1, -1, 0, 0, 1, 1, 1 };
	int[] dy = { -1, 0, 1, -1, 1, -1, 0, 1 };
	
	public boolean request(int[] q) {
		System.out.println("? " + q[0] + " " + q[1]);
		String s = in.next();
		if (s.equals("0")) {
			System.exit(0);
		}
		return s.equals("W");
	}
	
	public int toInt(int[] q) {
		return q[0] * INF + q[1];
	}
	
	public void solve() {
		HashMap<Integer, Boolean> map = new HashMap<>();
		int[] sz = { 0, 0 };
		int[] q = { INF / 4, INF / 4 };
		@SuppressWarnings("unchecked")
		ArrayList<Integer>[] ans = new ArrayList[2];
		ans[0] = new ArrayList<>();
		ans[1] = new ArrayList<>();
		boolean c0 = request(q);
		map.put(toInt(q), c0);
		Queue<Integer> both = new ArrayDeque<>();
		Queue<Integer> q0 = new ArrayDeque<>();
		Queue<Integer> q1 = new ArrayDeque<>();
		if (c0) {
			++sz[1];
			ans[1].add(toInt(q));
			for (int k = 0; k < 8; ++k) {
				q[0] = INF / 4 + dx[k];
				q[1] = INF / 4 + dy[k];
				q1.add(toInt(q));
			}
		} else {
			++sz[0];
			ans[0].add(toInt(q));
			for (int k = 0; k < 8; ++k) {
				q[0] = INF / 4 + dx[k];
				q[1] = INF / 4 + dy[k];
				q0.add(toInt(q));
			}
		}
		while (sz[0] < n && sz[1] < n) {
//			System.out.println("START " + c0 + " " + both.size() + " " + q0.size() + " " + q1.size());
			boolean find = false;
			boolean c;
			int h = -1;
			while (!both.isEmpty()) {
				int key = both.poll();
				if (map.containsKey(key)) {
					continue;
				}
				q[0] = key / INF;
				q[1] = key % INF;
				c = request(q);
				if (c) {
					++sz[1];
					ans[1].add(toInt(q));
				} else {
					++sz[0];
					ans[0].add(toInt(q));
				}
				map.put(key, c);
				for (int k = 0; k < 8; ++k) {
					int x = q[0] + dx[k];
					int y = q[1] + dy[k];
					int[] q_ = {x, y};
					h = toInt(q_);
					if (map.containsKey(h)) {
						continue;
					}
					int zero = 0;
					int one = 0;
					for (int k1 = 0; k1 < 8; ++k1) {
						int x1 = x + dx[k1];
						int y1 = y + dy[k1];
						int[] q2 = { x1, y1 };
						if (map.containsKey(toInt(q2))) {
							if (map.get(toInt(q2))) {
								++one;
							} else {
								++zero;
							}
						}
					}
					if (one > 0 && zero > 0) {
						both.add(h);
					} else if (one > 0) {
						q1.add(h);
					} else {
						assert (zero > 0);
						q0.add(h);
					}
				}
				find = true;
				break;
			}
			if (find) {
				continue;
			}
//			System.out.println(c0 + " " + sz[0] + " " + sz[1] + " " + q0.size() + " " + q1.size());
			if ((c0 && sz[0] == 0) || (!c0 && sz[1] == 0)) {
//				System.out.println("HERE1");
				Queue<Integer> queue;
				if (c0) {
					queue = q1;
				} else {
					queue = q0;
				}
//				System.out.println(queue.size());
				while (!queue.isEmpty()) {
					int key = queue.poll();
					if (map.containsKey(key)) {
						continue;
					}
//					System.out.println(key);
					q[0] = key / INF;
					q[1] = key % INF;
					c = request(q);
					if (c) {
						++sz[1];
						ans[1].add(toInt(q));
					} else {
						++sz[0];
						ans[0].add(toInt(q));
					}
					map.put(key, c);
					for (int k = 0; k < 8; ++k) {
						int x = q[0] + dx[k];
						int y = q[1] + dy[k];
						int[] q2 = {x, y};
						h = toInt(q2);
						if (map.containsKey(h)) {
							continue;
						}
						int zero = 0;
						int one = 0;
						for (int k1 = 0; k1 < 8; ++k1) {
							int x1 = x + dx[k1];
							int y1 = y + dy[k1];
							int[] q3 = {x1, y1};
							if (map.containsKey(toInt(q3))) {
								if (map.get(toInt(q3))) {
									++one;
								} else {
									++zero;
								}
							}
						}
//						System.out.println(h + " " + one + " " + zero);
						if (one > 0 && zero > 0) {
							both.add(h);
						} else if (one > 0) {
							q1.add(h);
						} else {
							assert (zero > 0);
							q0.add(h);
						}
//						System.out.println(sz[0] + " " + sz[1] + " " + both.size() + " " + q0.size() + " " + q1.size());
					}
					find = true;
					break;
				}
//				if (true) break;
			}
			if (find) {
				continue;
			}
//			System.out.println("HERE " + sz[0] + " " + sz[1]);
			int key = 0;
			for (Entry<Integer, Boolean> e : map.entrySet()) {
				if (e.getKey() % INF > key % INF) {
					key = e.getKey();
					c0 = e.getValue();
				}
			}
			if (c0) {
				sz[0] = 0;
				q0.clear();
				ans[0].clear();
			} else {
				sz[1] = 0;
				q1.clear();
				ans[1].clear();
			}
		}
		boolean col = sz[1] == n;
		if (col) {
			System.out.print("! W");
			for (int x : ans[1]) {
				System.out.print(" " + x / INF + " " + x % INF);
			}
			System.out.println();
		} else {
			System.out.print("! B");
			for (int x : ans[0]) {
				System.out.print(" " + x / INF + " " + x % INF);
			}
			System.out.println();
		}
	}
	
	public void run() {
		try {
			if (systemIO) {
				in = new FastScanner(System.in);
				out = new PrintWriter(System.out);
			} else {
				in = new FastScanner(new File("input.txt"));
				out = new PrintWriter(new File("output.txt"));
			}
			
			int t = in.nextInt();
			n = in.nextInt();
			
			for (int i = 0; i < t; ++i) {
				solve();
			}

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	class FastScanner {
		BufferedReader br;
		StringTokenizer st;

		FastScanner(File f) {
			try {
				br = new BufferedReader(new FileReader(f));
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}

		FastScanner(InputStream f) {
			br = new BufferedReader(new InputStreamReader(f));
		}

		String nextLine() {
			try {
				return br.readLine();
			} catch (IOException e) {
				return null;
			}
		}

		String next() {
			while (st == null || !st.hasMoreTokens()) {
				try {
					st = new StringTokenizer(br.readLine());
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			return st.nextToken();
		}

		int nextInt() {
			String s = next();
			int res = 0;
			if (s.charAt(0) == '-') {
				for (int i = 1; i < s.length(); i++) {
					res = 10 * res + s.charAt(i) - '0';
				}
				return -res;
			}
			for (int i = 0; i < s.length(); i++) {
				res = 10 * res + s.charAt(i) - '0';
			}
			return res;
		}

		long nextLong() {
			return Long.parseLong(next());
		}

		double nextDouble() {
			return Double.parseDouble(next());
		}

	}

	public static void main(String[] arg) {
		new Main().run();
	}
}
