package main

import "fmt"

func solve(h, k int) []int {
	type Item struct {
		key int
		min int
		max int
	}
	items := []Item{
		{2, 0, 0},
		{4, 0, 4},
	}
	for i := 3; i <= k+1; i++ {
		value := 1 << i
		lastItem := items[len(items)-1]
		items = append(items, Item{
			key: value,
			min: lastItem.min*2 + value,
			max: lastItem.max*2 + value,
		})
	}

	result := make([]int, 0)
	for len(items) > 0 && h > 0 {
		id := 0
		for id+1 < len(items) && items[id+1].min <= h {
			id++
		}
		subt := items[id].max
		if id+1 == len(items) {
			subt -= 4
		}
		if subt > h {
			subt = h
			subt -= subt % 4
		}
		result = append(result, items[id].key)
		h -= subt
		items = items[:len(items)-1]
	}

	if h != 0 {
		return nil
	}
	return result
}

func main() {
	var n, k int
	fmt.Scan(&n, &k)

	for range n {
		var h int
		fmt.Scan(&h)

		result := solve(h, k)

		if result == nil {
			fmt.Println("-1")
		} else {
			fmt.Print(len(result))
			for _, v := range result {
				fmt.Printf(" %d", v)
			}
			fmt.Println()
		}
	}
}
