#include <bits/stdc++.h>

using ll = long long;

void solveTest() {
    std::mt19937 rng(566);
    
    int n;
    std::cin >> n;
    std::vector<std::pair<std::string, std::string>> names(n);
    for (auto& [x, y] : names) {
        std::cin >> x >> y;
    }

    std::vector<int> toCheck;

    for (int i = n - 2; i > 0; --i) {
        auto[x, y] = names[i];
        auto[px, py] = names[i - 1];

        if (x == px || y == py) {
            continue;
        }

        toCheck.push_back(i - 1);
    }

    if (toCheck.empty()) {
        std::cout << "Yes\n";
        return;
    }

    const int CHECKS_EACH = 500;
    const int CHECKS = CHECKS_EACH * double(n) / toCheck.size();

    for (int i : toCheck) {
        const auto& [px, py] = names[i];
        for (int iter = 0; iter < CHECKS; ++iter) {
            int j = std::uniform_int_distribution<int>(i + 2, n - 1)(rng);
            if (px == names[j].first || py == names[j].second) {
                std::cout << "No\n";
                return;
            }
        }
    }

    std::cout << "Yes\n";
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);
    int t;
    std::cin >> t;
    while (t--) {
        solveTest();
    }
    
    return 0;
}
