#define TIME_FOR_PAIR_OF_KEY_AND_LOCK 0
#include <iostream>
#include <vector>
#include <algorithm>
#include <unordered_map>
#include <unordered_set>

using Coordinate = int32_t;
using PathLength = int64_t;
using Index = uint32_t;

const PathLength IMPOSSIBLE_LENGTH = -1;

struct KeyLock {
    Coordinate key, lock;
};

std::istream& operator>>(std::istream& in, KeyLock& key_lock) {
    return in >> key_lock.key >> key_lock.lock;
}

struct Instance {
    std::vector<KeyLock> key_locks;
    Coordinate start, finish;
};

std::istream& operator>>(std::istream& in, Instance& instance) {
    Index n = 0;
    in >> n >> instance.start >> instance.finish;
    instance.key_locks.resize(n);
    for (KeyLock& key_lock : instance.key_locks)
        in >> key_lock;
    return in;
}

enum ActionType {
    GO, PICK, UNLOCK
};

std::ostream& operator<<(std::ostream& out, const ActionType action_type) {
    if (action_type == GO)
        out << "go";
    else if (action_type == PICK)
        out << "pick";
    else
        out << "unlock";
    return out;
}

struct Action {
    ActionType type;
    Coordinate x;
};

std::ostream& operator<<(std::ostream& out, const Action action) {
    return out << action.type << ' ' << action.x;
}

struct Actions {
    std::vector<Action> v;
};

std::ostream& operator<<(std::ostream& out, const Actions& actions) {
    out << actions.v.size() << '\n';
    for (const Action action : actions.v)
        out << action << '\n';
    return out;
}

template<class Int>
int8_t get_sign(const Int& x) {
    return (x > 0) - (x < 0);
}

PathLength find_ans(const Instance& instance) {
    using SignedIndex = std::make_signed_t<Index>;
    struct InterestingPoint {
        SignedIndex index;
        bool is_key() const {
            return index >= 0;
        }
        bool is_lock() const {
            return index < 0;
        }
        Index get_index() const {
            return is_key() ? index : -1 - index;
        }
    };
    const Index n = instance.key_locks.size();
    std::unordered_map<Coordinate, InterestingPoint> interesting_points;
    for (Index i = 0; i < n; ++i) {
        interesting_points[instance.key_locks[i].key] = {.index = static_cast<SignedIndex>(i)};
        interesting_points[instance.key_locks[i].lock] = {.index = static_cast<SignedIndex>(-1 - i)};
    }
    Coordinate x = instance.start;
    Coordinate direction = get_sign(instance.finish - instance.start);
    std::vector<bool> picked_keys(n);
    PathLength ans = 0;
    std::unordered_set<Coordinate> stuck;
    while (x != instance.finish) {
        x += direction;
        ++ans;
        auto it = interesting_points.find(x);
        if (it == interesting_points.end())
            continue;
        if (it->second.is_key()) {
            picked_keys[it->second.get_index()] = true;
            interesting_points.erase(it);
            continue;
        }
        if (picked_keys[it->second.get_index()]) {
            interesting_points.erase(it);
            ans += TIME_FOR_PAIR_OF_KEY_AND_LOCK;
        }
        direction = -direction;
        if (!stuck.insert(x).second) {
            return -1;
        }
    }
    return ans;
}

bool solve_test([[maybe_unused]] const Index test_index) {
    Instance instance;
    if (!(std::cin >> instance))
        return false;
    PathLength ans = find_ans(instance);
    std::cout << ans << '\n';
    return true;
}

void solve_tests() {
    Index n_tests;
    std::cin >> n_tests;
    for (Index test_index = 0; test_index < n_tests; ++test_index)
        if (!solve_test(test_index))
            return;
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);
    solve_tests();
}
