#include <iostream>
#include <iomanip>

int main() {
    int n; // зарплата
    int p; // процент инфляции

    // Чтение входных данных
    std::cin >> n >> p;

    // Количество месяцев в году
    const int months = 10;
    
    // Изначальная зарплата
    double salary = n;
    
    // Сумма, которую маг фактически заработал за год
    double actual_income = salary * months;

    // Сумма, которую маг должен был заработать с учетом инфляции
    double expected_income = 0.0;

    // Расчет ожидаемого дохода с учетом инфляции
    for (int month = 0; month < months; ++month) {
        expected_income += salary;
        // Увеличение зарплаты на процент инфляции
        salary += salary * (p / 100.0);
    }

    // Сумма недополученного дохода
    double lost_income = expected_income - actual_income;

    // Вывод результата
    std::cout << std::fixed << std::setprecision(0) << lost_income << std::endl;

    return 0;
}
