#include "testlib.h"
#include <bits/stdc++.h>
using namespace std;

const int max_coord = int(1e4);

int main (int argc, char *argv[])
{
    registerGen(argc, argv, 1);

    const int n = opt<int>("n");


    vector<pair<int, int>> segs;

    int cnt = 2, sum_coord = 1;
    bool ok = true;
    segs = {pair{0, 1}, pair{1, 0}};

    for (int sum = 2; ok; sum++)
    {
        for (int i = 1; 2 * i < sum && ok; i++)
        if (__gcd(i, sum) == 1)
        {
            if (sum_coord + sum <= max_coord)
            {
                sum_coord += sum;
                segs.emplace_back(i, sum - i);
                segs.emplace_back(sum - i, i);
                cnt += 2;
            }
            else
                ok = false;
        }
    }

    sort(segs.begin(), segs.end(), [&] (const pair<int, int> &p, const pair<int, int> &q)
         {
            /// p.first / p.second < q.first / q.second
            return p.first * q.second < p.second * q.first;
         });

//    for (auto pr : segs)
//        cerr << pr.first << ' ' << pr.second << endl;

    vector<pair<int, int>> pts{pair{0, 0}};
    for (int sign = +1; sign >= -1; sign -= 2)
    for (int i = 0; i < int(segs.size()); i++)
        pts.emplace_back(pts.back().first + segs[i].first * sign,
                         pts.back().second + segs[i].second * sign);

    assert(pts.back() == pts.front());
    pts.pop_back();


    assert(int(pts.size()) >= n);
    shuffle(pts.begin(), pts.end());
    pts.resize(n);

    int min_x = max_coord + 1, max_x = -1;
    int min_y = max_coord + 1, max_y = -1;

    for (const auto &pr : pts)
    {
        min_x = min(min_x, pr.first);
        max_x = max(max_x, pr.first);

        min_y = min(min_y, pr.second);
        max_y = max(max_y, pr.second);
    }

    const int shift_x = rnd.next(-min_x, max_coord - max_x);
    const int shift_y = rnd.next(-min_y, max_coord - max_y);

    for (auto &it : pts)
    {
        it.first += shift_x;
        it.second += shift_y;
    }

    cout << n << endl;
    for (int i = 0; i < n; i++)
        cout << pts[i].first << ' ' << pts[i].second << "\n";
}
