#include "testlib.h"
#include <bits/stdc++.h>
using namespace std;

const int max_coord = int(1e4);
const double pi = double(acosl(-1));

int main (int argc, char *argv[])
{
    registerGen(argc, argv, 1);

    const int n = opt<int>("n");
    const int radius = opt<int>("radius");
    ensure(2 * radius <= max_coord);

    double x, y;
    if (2 * radius < max_coord)
    {
        x = rnd.next(double(radius), double(max_coord - radius));
        y = rnd.next(double(radius), double(max_coord - radius));
    }
    else
        x = y = double(radius);

    set<pair<int, int>> pts;
    int fails = 0;

    while (int(pts.size()) < n && fails < 100)
    {
        const double angle = rnd.next(double(0), double(2 * pi));
        const double target_x = x + radius * cos(angle);
        const double target_y = y + radius * sin(angle);

        const pair<int, int> cur{int(target_x), int(target_y)};
        assert(0 <= min(cur.first, cur.second) && max(cur.first, cur.second) <= max_coord);

        if (pts.count(cur))
            fails++;
        else
        {
            pts.insert(cur);
            fails = 0;
        }
    }

    for (int dst = 0; int(pts.size()) < n; dst++)
    {
        const int orig_x = int(x);
        const int orig_y = int(y);

        for (int dx = -dst; dx <= +dst && int(pts.size()) < n; dx++)
        for (int dy = -dst; dy <= +dst && int(pts.size()) < n; dy++)
        {
            const int nx = orig_x + dx, ny = orig_y + dy;
            if (0 <= min(nx, ny) && max(nx, ny) <= max_coord)
                pts.emplace(nx, ny);
        }
    }


    vector<pair<int, int>> v(pts.begin(), pts.end());
    shuffle(v.begin(), v.end());

    cout << n << endl;
    for (int i = 0; i < n; i++)
        cout << v[i].first << ' ' << v[i].second << "\n";
}
