#include <bits/stdc++.h>
using namespace std;

#define double long long
// структура для описания точки
struct Point {
    double x, y;
};

// структура для задания прямой (коэффициенты уравнения Ax + By + C = 0)
struct Line {
    double A, B, C;
};

// расчитываем расстояние между двумя точками
double distance(const Point &p1, const Point &p2) {
    return hypot(p1.x - p2.x, p1.y - p2.y); // использование стандартной функции hypot для расчёта расстояния
}

// получаем коэффициенты прямой, проходящей через две точки
Line make_line(Point p1, Point p2) {
    double A = p2.y - p1.y;
    double B = p1.x - p2.x;
    double C = A*p1.x + B*p1.y;
    return {A, B, -C}; // обратите внимание на знак минус перед C
}

// получаем уравнение прямой, перпендикулярной заданной прямой и проходящей через точку
Line perpendic_line(Line l, Point p) {
    double A_perp = -l.B;
    double B_perp = l.A;
    double C_perp = -(A_perp * p.x + B_perp * p.y);
    return {A_perp, B_perp, C_perp};
}

int main() {
    int n;
    cin >> n;

    // чтение координат точек
    vector<Point> points(n);
    for(int i = 0; i < n; ++i) {
        cin >> points[i].x >> points[i].y;
    }

    // находим самые удалённые точки
    double max_dist = 0;
    int idx1 = 0, idx2 = 0;
    for(int i = 0; i < n; ++i) {
        for(int j = i+1; j < n; ++j) {
            double curr_dist = distance(points[i], points[j]);
            if(curr_dist > max_dist) {
                max_dist = curr_dist;
                idx1 = i;
                idx2 = j;
            }
        }
    }

    // определяем первую прямую, проходящую через наиболее удалённые точки
    Line first_line = make_line(points[idx1], points[idx2]);

    // определяем перпендикулярные прямые, проходящие через каждую из точек
    Line second_line = perpendic_line(first_line, points[idx1]); // первая перпендикулярная прямая
    Line third_line = perpendic_line(first_line, points[idx2]);  // вторая перпендикулярная прямая

   /* cout << fixed << setprecision(0);
    cout << "Первая прямая (через обе точки): " << first_line.A << "*x + " << first_line.B << "*y + " << first_line.C << " = 0\n";
    cout << "Вторая прямая (перпендикулярная первой, через первую точку): " << second_line.A << "*x + " << second_line.B << "*y + " << second_line.C << " = 0\n";
    cout << "Третья прямая (перпендикулярная первой, через вторую точку): " << third_line.A << "*x + " << third_line.B << "*y + " << third_line.C << " = 0\n";
*/
cout << second_line.A <<" "<<second_line.B <<" "<< second_line.C<<'\n';
cout << third_line.A <<" "<< third_line.B <<" "<< third_line.C<<'\n';
    return 0;
}