#include <iostream>
#include <string>
#include <algorithm>

using namespace std;

// Функция для преобразования числа в двоичное строковое представление
string toBinary(int num) {
    string binary = "";
    while(num > 0){
        if(num % 2)
            binary += '1';
        else
            binary += '0';
        num /= 2;
    }
    reverse(binary.begin(), binary.end());
    return binary;
}

// Функция для удаления начальных нулей из строки
void removeLeadingZeros(string& s) {
    int i = 0;
    while(i < s.size() && s[i] == '0')
        ++i;
    // Если все символы были нулями, оставляем хотя бы один символ
    if(i >= s.size())
        s = "0";
    else
        s.erase(s.begin(), s.begin()+i);
}

// Основная функция для подсчета количества бросков
int countThrows(int n) {
    int steps = 0;
    while(n != 0) {
        // Получаем двоичное представление числа
        string binStr = toBinary(n);
        
        // Переворачиваем строку
        reverse(binStr.begin(), binStr.end());
        
        // Убираем начальные нули
        removeLeadingZeros(binStr);
        
        // Преобразуем обратно в десятичный вид и вычитаем единицу
        n = stoi(binStr, nullptr, 2) - 1;
        
        // Инкрементируем счётчик действий
        steps++;
    }
    
    return steps;
}

int main() {
    int n;
    cin >> n;
    
    cout << countThrows(n) << endl;
    return 0;
}
