#include "testlib.h"

const size_t MIN_T = 1, MAX_T = 10'000;
const size_t MIN_N = 1, MAX_N = 200'000;
const size_t MIN_S = 1, MAX_S = 200'000;

const pattern SCORE(std::format("[A-G]{{{},{}}}", MIN_N, MAX_N));

int main(int argc, char* argv[]) {
    registerValidation(argc, argv);
    const size_t t = inf.readUnsignedLong(MIN_T, MAX_T, "T");
    inf.readEoln();
    size_t total_length = 0;
    for (size_t i = 0; i < t; i++) {
        setTestCase(i);
        size_t cur_length = inf.readLine(SCORE, "score").size();
        total_length += cur_length;
        ensuref(total_length > 0, "string is empty");
        ensuref(total_length <= MAX_S, "%s", std::format("total length {} exceeded the limit of {}", total_length, MAX_S).c_str());
    }
    inf.readEof();
}
