#include <iostream>
#include <iomanip>

bool isMagicalTime(int hour, int minute) {
    // Форматируем время в строку HH:MM
    std::string time = std::to_string(hour);
    if (hour < 10) time = "0" + time; // Добавляем ведущий ноль, если нужно

    time += ":";
    
    time += std::to_string(minute);
    if (minute < 10) time += "0"; // Добавляем ведущий ноль, если нужно
    time += std::to_string(minute);

    // Проверяем условия
    return (time[1] == '2' && time[2] == '3' && time[3] == '9') || // X2:39
           (time[0] == '2' && (time[1] == '0' || time[1] == '3') && time[3] == '9') || // 2X:39
           (time[0] == '2' && time[1] == '3' && time[3] == '9') || // 23:X9
           (time[0] == '2' && time[1] == '3' && time[4] == '9'); // 23:9X
}

int main() {
    int H, M;
    std::cin >> H;
    std::cin >> M;

    int count = 0;

    for (int hour = 0; hour < H; ++hour) {
        for (int minute = 0; minute < M; ++minute) {
            if (isMagicalTime(hour, minute)) {
                count++;
            }
        }
    }

    std::cout << count << std::endl;
    
    return 0;
}
