#include <iostream>
using namespace std;

// Функция проверки соответствия времени одному из условий
bool isMagicNumber(int hour, int minute) {
    // Преобразуем часы и минуты в строки для удобства проверки
    string h = (hour < 10 ? "0" : "") + to_string(hour);
    string m = (minute < 10 ? "0" : "") + to_string(minute);
    
    // Проверяем все четыре случая
    return (
        // Случай X2:39
        (h.back() == '2' && m == "39") ||
        
        // Случай 2X:39
        (h.front() == '2' && (h.back() == '0' || h.back() == '3') && m == "39") ||
        
        // Случай 23:X9
        (h == "23" && (m.front() == '0' || m.front() == '3') && m.back() == '9') ||
        
        // Случай 23:9X
        (h == "23" && m.front() == '9')
    );
}

int main() {
    int H, M;
    
    // Читаем входные данные
    cin >> H >> M;
    
    // Переменная для подсчета количества совпадений
    int count = 0;
    
    // Перебор всех возможных комбинаций часов и минут
    for (int hour = 0; hour < H; ++hour) {
        for (int minute = 0; minute < M; ++minute) {
            if (isMagicNumber(hour, minute)) {
                count++;
            }
        }
    }
    
    // Вывод результата
    cout << count << endl;
    
    return 0;
}
