import java.io.*
import java.util.BitSet

class FastScanner(private val input: InputStream) {
  companion object {
    val zero = 0.toByte()
    val cr = '\r'.toByte()
    val nl = '\n'.toByte()
    val BUFFER_SIZE = 0x10000
  }
  private val b = ByteArray(BUFFER_SIZE)
  private var n = 0
  private var pos = 0
  private var eof = false
  private fun read ():Boolean {
    if (eof) {
      return false
    }
    pos = 0
    n = input.read(b)
    if (n < 0) {
      eof = true
    }
    return n > 0
  }
  private fun nextByte(): Byte {
    if (pos >= n && !read ()) {
      return 0
    }
    val r = b[pos]
    ++pos
    return r
  }
  private fun skipBlanks(): Byte {
    while(true) {
      val b = nextByte()
      if(b > 32 || b < 1) return b
    }
  }
  fun nextInt():Int {
    var b = skipBlanks()
    check(b > 0)
    if (b < 48) {
      var t = 0
      while (true) {
        b = nextByte ()
        if (b <= 32) {
          return t
        }
        t = 10 * t - (b - 48)
      }
    } else {
      var t = b - 48
      while (true) {
        b = nextByte ()
        if (b <= 32) {
          return t
        }
        t = 10 * t + (b - 48)
      }
    }
  }
}

const val M = 999_983

fun next(s: Int): Int {
  return ((s.toLong() * 618_023L + 1L) % M.toLong()).toInt()
}

fun main() {
  val (n, s0) = run {
    val r = FastScanner(System.`in`)
    val n = r.nextInt()
    val s = r.nextInt()
    n to s
  }
  val bs = BitSet(M)
  val rs = BitSet(M)
  var s = s0
  repeat (n) {
    s = next(s)
    val bits = (s / 2) + 1
    val x = bs.get(s + 1 - bits, s + 1)
    x.and(rs.get(M - bits, M))
    val l = x.toLongArray()
    val c = l.fold(0L) { u, v -> u xor v }
    if (java.lang.Long.bitCount(c) % 2 == 0) {
      bs.set(s)
      rs.set(M - 1 - s)
    }
  }
  println(bs.cardinality())
}
