use std::io;
use std::iter;
use io::{BufRead, Write};
use std::str::FromStr;

#[cfg(dprintln)]
#[allow(unused_macros)]
macro_rules! dprintln { ($( $args:expr ),*) => { eprintln!( $( $args ),* ); } }

#[cfg(not(dprintln))]
#[allow(unused_macros)]
macro_rules! dprintln { ($( $args:expr ),*) => { } }

struct BitSet(Vec<u64>);

impl BitSet {
  fn set(&mut self, i: usize) {
    self.0[i >> 6] |= 1u64 << (i & 63);
  }
  fn get(&self, i: usize) -> bool {
    if let Some(v) = self.0.get(i >> 6) {
      (v & (1u64 << (i & 63))) != 0
    } else {
      false
    }
  }
  fn new(n: usize) -> Self {
    BitSet(vec![0u64; (n + 63) >> 6])
  }
}

struct Scanner<I> {
  it: I,
}

impl<I: std::iter::Iterator<Item=String>> Scanner<I> {
  fn next<A:FromStr>(&mut self) -> A {
    if let Ok(x) = self.it.next().unwrap().parse::<A>() {
      x
    } else {
      panic!("parse failed")
    }
  }
}

fn f<I: Iterator<Item=u64>>(a: &[u64], jt: I, k: usize) -> bool {
  let mut it = jt.zip(a.iter()).map(|(u, &v)| (u & v));
  let n = k / 64;
  let rem = k % 64;
  let mut t = 0;
  for _ in 0 .. n {
    t ^= it.next().unwrap();
  }
  let mut c = t.count_ones();
  if rem > 0 {
    let j = it.next().unwrap();
    for i in 0 .. rem {
      if (j & (1u64 << i)) != 0 {
        c += 1;
      }
    }
  }
  c % 2 == 0
}

fn main() -> io::Result<()> {
  let stdin = io::stdin();
  let it = stdin
    .lock()
    .lines()
    .flat_map(|s| {
       s.unwrap().split_whitespace()
        .map(|s| s.to_owned())
        .collect::<Vec<_>>()
        .into_iter()
      });
  let mut r = Scanner{it};
  let stdout = io::stdout();
  let mut o = io::BufWriter::with_capacity(1 << 20, stdout.lock());
  let n = r.next::<usize>();
  let mut s = r.next::<usize>();
  let mut bs = BitSet::new(999_983);
  let mut ans = 0;
  for _ in 0 .. n {
    s = (s * 618_023 + 1) % 999_983;
    let t = s + 1;
    let k = (t + 63) / 64;
    let shift = (t % 64) as u32;
    let bits = (s + 2) / 2;
    let c = if shift > 0 {
      let shift_left = 64 - shift;
      let it = bs.0[0 .. k].iter().rev().zip(bs.0[0 .. k-1].iter().rev().chain( iter::once(&0))).map(|(&u, &v)| ((u << shift_left) | (v >> shift)).reverse_bits());
      f (&bs.0, it, bits)
    } else {
      let it = bs.0[0..k].iter().rev().map(|&u| u.reverse_bits());
      f (&bs.0, it, bits)
    };
    dprintln!("s = {}, c = {}", s, c);
    if c {
      if !bs.get(s as usize) {
        bs.set(s as usize);
        ans += 1;
      }
    }
  }
  writeln!(o, "{}", ans)?;
  o.flush()
}
